/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.tileentities.AbstractScarecrowTileEntity;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerField
extends AbstractContainerMenu {
    private static final int LINES_PER_OFFSET = 3;
    private final IItemHandler inventory;
    private final IColony colony;
    private final AbstractScarecrowTileEntity tileEntity;

    public static ContainerField fromFriendlyByteBuf(int windowId, Inventory inv, FriendlyByteBuf packetBuffer) {
        BlockPos tePos = packetBuffer.m_130135_();
        return new ContainerField(windowId, inv, tePos);
    }

    public ContainerField(int windowId, Inventory playerInventory, BlockPos pos) {
        super(ModContainers.field, windowId);
        int i;
        Level world = playerInventory.f_35978_.f_19853_;
        if (world.m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
            pos = pos.m_7495_();
        }
        this.colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
        this.tileEntity = (AbstractScarecrowTileEntity)world.m_7702_(pos);
        this.inventory = this.getTileEntity().getInventory();
        boolean extraOffset = false;
        this.m_38897_((Slot)new SlotItemHandler(this.inventory, 0, 80, 34));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int index) {
        ItemStack transfer = ItemStackUtils.EMPTY;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return transfer;
        }
        transfer = slot.m_7993_();
        if (index == 0 ? !this.m_38903_(transfer, 1, 37, true) : !this.m_38903_(transfer, 0, 1, false)) {
            return ItemStackUtils.EMPTY;
        }
        return transfer;
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        if (this.colony == null) {
            return false;
        }
        return this.colony.getPermissions().hasPermission(playerIn, Action.ACCESS_HUTS);
    }

    public AbstractScarecrowTileEntity getTileEntity() {
        return this.tileEntity;
    }
}

